package net.damschen.swatchit.ui.elements

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Error
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.testTag
import androidx.compose.ui.res.stringResource
import net.damschen.swatchit.R

@Composable
fun ErrorDialog(
    text: String,
    testTag: String = "ErrorDialog",
    onCancel: () -> Unit,
    onRetry: () -> Unit
) {
    AlertDialog(
        modifier = Modifier.testTag(testTag),
        icon = {
            Icon(
                Icons.Default.Error,
                contentDescription = stringResource(R.string.error_icon_description)
            )
        }, title = {
            Text(text = stringResource(R.string.something_went_wrong))
        }, text = {
            Text(text = text)
        }, onDismissRequest = {
            onCancel()
        }, confirmButton = {
            TextButton(modifier = Modifier.testTag("RetryErrorDialogButton"), onClick = {
                onRetry()
            }) {
                Text(stringResource(R.string.retry))
            }
        }, dismissButton = {
            TextButton(modifier = Modifier.testTag("CancelErrorDialogButton"), onClick = {
                onCancel()
            }) {
                Text(stringResource(R.string.cancel))
            }
        })
}