package net.damschen.swatchit.infrastructure.database

import androidx.room.withTransaction

interface TransactionProvider {
    suspend fun <R> executeTransaction(block: suspend () -> R): R
}

class RoomTransactionProvider(private val database: AppDatabase) : TransactionProvider {
    override suspend fun <R> executeTransaction(block: suspend () -> R): R {
        return database.withTransaction(block)
    }

}