package net.damschen.swatchit.infrastructure.database

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Insert
import androidx.room.Query
import androidx.room.Transaction
import androidx.room.Update
import kotlinx.coroutines.flow.Flow

@Dao
interface SwatchDao {

    @Transaction
    @Query("SELECT * FROM swatches")
    fun get(): Flow<List<SwatchAggregate>>

    @Insert
    suspend fun insert(swatch: SwatchEntity): Long

    @Update
    suspend fun update(swatch: SwatchEntity)

    @Delete(entity = SwatchEntity::class)
    suspend fun delete(id: SwatchId)

    @Transaction
    @Query("SELECT * FROM swatches WHERE id = :id")
    suspend fun get(id: Int): SwatchAggregate?

    @Query("SELECT EXISTS(SELECT 1 FROM swatches WHERE id = :id)")
    suspend fun exists(id: Int?): Boolean
}