package net.damschen.swatchit.infrastructure.database

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.ForeignKey
import androidx.room.PrimaryKey

@Entity(
    tableName = "measurements", foreignKeys = [ForeignKey(
        entity = SwatchEntity::class,
        parentColumns = arrayOf("id"),
        childColumns = arrayOf("swatchId"),
        onDelete = ForeignKey.CASCADE
    )]
)
data class MeasurementEntity(
    @ColumnInfo(name = "type") val type: MeasurementType,
    @ColumnInfo(name = "count") var count: Int,
    @ColumnInfo(name = "size") var size: Double,
    @ColumnInfo(name = "swatchId", index = true) var swatchId: Int
) {
    @PrimaryKey(autoGenerate = true)
    var id: Int = 0
}

enum class MeasurementType {
    Stitches, Rows
}

