package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.R
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

@JvmInline
value class GaugeCount(val value: Int) {
    init {
        require(validate(value) is ValidationResult.Success) { "Count invalid" }
    }

    companion object {
        fun validate(value: Int): ValidationResult {
            return when {
                value < MIN -> ValidationResult.Error(R.string.must_be_greater_than_zero)
                value > MAX -> ValidationResult.Error(R.string.max_99)
                else -> ValidationResult.Success
            }
        }

        fun validate(value: String): ValidationResult {
            val trimmed = value.trim()
            val count = trimmed.toIntOrNull()
            return when {
                trimmed.isBlank() -> ValidationResult.Error(R.string.mandatory)
                count == null -> ValidationResult.Error(R.string.invalid_number)
                else -> validate(count)
            }
        }

        fun create(value: String): GaugeCount {
            val trimmed = value.trim()
            require(validate(trimmed) is ValidationResult.Success) { "Count invalid" }
            return GaugeCount(trimmed.toInt())
        }
    }

    override fun toString(): String {
        return value.toString()
    }
}

private const val MIN = 1
private const val MAX = 99