package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.R
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

@JvmInline
value class Count(val value: Long) {
    init {
        require(validate(value) is ValidationResult.Success) { "Count invalid" }
    }

    companion object {
        fun validate(value: Long): ValidationResult {
            return when {
                value < MIN -> ValidationResult.Error(R.string.must_be_greater_than_zero)
                else -> ValidationResult.Success
            }
        }

        fun validate(value: String): ValidationResult {
            val trimmed = value.trim()
            when {
                trimmed.isBlank() -> return ValidationResult.Success
                trimmed.length >= MAX_CHARS -> return ValidationResult.Error(R.string.number_too_big)
            }

            val count = trimmed.toLongOrNull()
            return when {
                count == null -> ValidationResult.Error(R.string.invalid_number)
                else -> validate(count)
            }
        }

        fun create(value: String): Count? {
            val trimmed = value.trim()
            require(validate(trimmed) is ValidationResult.Success) { "Count invalid" }
            val numericValue = trimmed.toLongOrNull()
            return numericValue?.let { Count(it) }
        }
    }

    override fun toString(): String {
        return value.toString()
    }
}

private const val MIN = 1
private const val MAX_CHARS = Long.MAX_VALUE.toString().length