# SwatchIt
SwatchIt is an Android app that keeps track of all of your knitted swatches, so that you can minimize the time spend on swatching and maximize the time knitting.

[<img src="https://f-droid.org/badge/get-it-on.png"
alt="Get it on F-Droid"
height="80">](https://f-droid.org/packages/net.damschen.swatchit)

SwatchIt is build with Android Compose, Hilt and Room. The tests are written with help of Robolectric. The structure follows the MVVM architecture.

ViewModels do create coroutines to fetch data ([here's a link to the docs](https://developer.android.com/kotlin/coroutines/coroutines-best-practices#viewmodel-coroutines))

The project uses [gradle dependency verification](https://developer.android.com/build/dependency-verification)

## Copyright notice
Copyright (C) 2025  Katharina Damschen

This program is free software: you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with this program. If not, see <https://www.gnu.org/licenses/>.

## Create a Release
- Bump the versionCode and versionName in the apps `build.gradle.kts` file.
- Add a changelog to `/metadata/en-US/changelogs`
- Commit and tag the commit with `v.%versionName` and push
- Build and sign the apk (see instructions below)
- Create the CycloneDX SBOM (see instructions below)
- Create a release on Codeberg and upload the signed apk and SBOM

### Build and Sign the APK
To create a Release run:
```bash
./gradlew assembleRelease
```
Rename the apk:
```bash
mv app/build/outputs/apk/release/app-release-unsigned.apk app/build/outputs/apk/release/swatchit-%versionName.apk
```
Sign the apk:
```bash
apksigner sign --ks-key-alias YOUR_KEY_ALIAS --ks YOUR_KEYSTORE_PATH app/build/outputs/apk/release/swatchit-%versionName.apk
```

### CycloneDX SBOM creation
A Software Bill of Materials (SBOM) can be created by running:
```bash
./gradlew cyclonedxBom
```
The aggregated SBOM can be found in `build/reports/cyclonedx/bom.{json,xml}`.