package net.damschen.swatchit.test.ui.models

import junit.framework.TestCase.assertEquals
import junit.framework.TestCase.assertFalse
import junit.framework.TestCase.assertTrue
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize
import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.Gauge
import net.damschen.swatchit.ui.models.GaugeFormState
import net.damschen.swatchit.ui.models.ValidatedInput
import org.junit.Test

class GaugeFormStateTests {
    @Test
    fun isValid_noErrors_returnsTrue() {
        val gaugeFormState = GaugeFormState(
            nrOfStitches = ValidatedInput(""),
            nrOfRows = ValidatedInput(""),
            size = ValidatedInput("")
        )

        assertTrue(gaugeFormState.isValid())
    }

    @Test
    fun isValid_errors_returnsFalse() {
        val gaugeFormState = GaugeFormState(
            nrOfStitches = ValidatedInput("invalid", 23),
            nrOfRows = ValidatedInput("", 24),
            size = ValidatedInput("")
        )

        assertFalse(gaugeFormState.isValid())
    }

    @Test
    fun fromGauge_gaugeNull_setsStateEmpty() {
        val gaugeFormState = GaugeFormState.fromGauge(null)

        assertEquals(ValidatedInput(""), gaugeFormState.nrOfStitches)
        assertEquals(ValidatedInput(""), gaugeFormState.nrOfRows)
        assertEquals(ValidatedInput(""), gaugeFormState.size)
    }

    @Test
    fun toGauge_afterFromGauge_createsEqualSwatch() {
        val expected = Gauge(GaugeCount(10), GaugeCount(12), GaugeSize(13.0))
        val swatchFormState = GaugeFormState.fromGauge(expected)
        val actual = swatchFormState.toGauge()

        assertEquals(expected, actual)
    }
}