package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.Pattern
import org.junit.Assert.assertEquals
import org.junit.Assert.assertFalse
import org.junit.Assert.assertNotNull
import org.junit.Assert.assertThrows
import org.junit.Assert.assertTrue
import org.junit.Test

class PatternTests {
    @Test
    fun create_validInput_createsPattern() {
        val value = "Stockinette"
        val pattern = Pattern.create(value)!!
        assertEquals(value, pattern.value)
    }

    @Test
    fun create_emptyName_returnsNull() {
        val pattern = Pattern.create("")
        assertEquals(null, pattern)
    }

    @Test
    fun create_tooLongValue_throws() {
        assertThrows(IllegalArgumentException::class.java) {
            Pattern.create("A".repeat(151))
        }
    }

    @Test
    fun validate_validInput_returnsIsValid() {
        val value = "Stockinette"
        val validationResult = Pattern.validate(value)
        assertTrue(validationResult.isValid)
    }

    @Test
    fun validate_tooLongValue_returnsErrorMessageId() {
        val value = "A".repeat(151)
        val validationResult = Pattern.validate(value)
        assertFalse(validationResult.isValid)
        assertNotNull(validationResult.errorMessageId)
    }

    @Test
    fun toString_validValue_printsValue() {
        val pattern = Pattern.create("Abc")
        assertEquals("Abc", pattern.toString())
    }
}