package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.Notes
import org.junit.Assert.assertEquals
import org.junit.Assert.assertFalse
import org.junit.Assert.assertNotNull
import org.junit.Assert.assertThrows
import org.junit.Assert.assertTrue
import org.junit.Test

class NotesTests {

    @Test
    fun create_validInput_createsNotes() {
        val note = "This is a note!"
        val notes = Notes.create(note)!!
        assertEquals(note, notes.value)
    }

    @Test
    fun create_emptyInput_returnsNull() {
        val notes = Notes.create("")
        assertEquals(null, notes)
    }

    @Test
    fun create_tooLongValue_throws() {
        assertThrows(IllegalArgumentException::class.java) {
            Notes.create("A".repeat(501))
        }
    }

    @Test
    fun validate_validInput_returnsIsValid() {
        val note = "This is a note!"
        val validationResult = Notes.validate(note)
        assertTrue(validationResult.isValid)
    }

    @Test
    fun validate_tooLongValue_returnsErrorId() {
        val note = "A".repeat(501)
        val validationResult = Notes.validate(note)
        assertFalse(validationResult.isValid)
        assertNotNull(validationResult.errorMessageId)
    }
    @Test
    fun toString_validValue_printsValue() {
        val notes = Notes.create("Abc")
        assertEquals("Abc", notes.toString())
    }
}