package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.Name
import org.junit.Assert.assertEquals
import org.junit.Assert.assertFalse
import org.junit.Assert.assertNotNull
import org.junit.Assert.assertThrows
import org.junit.Assert.assertTrue
import org.junit.Test

class NameTests {
    @Test
    fun create_validInput_createsName() {
        val value = "This is a name!"
        val name = Name.create(value)!!
        assertEquals(value, name.value)
    }

    @Test
    fun create_emptyInput_returnsNull() {
        val name = Name.create("")
        assertEquals(null, name)
    }

    @Test
    fun create_tooLongValue_throws() {
        assertThrows(IllegalArgumentException::class.java) {
            Name.create("A".repeat(51))
        }
    }

    @Test
    fun validate_validInput_returnsIsValid() {
        val value = "This is a name!"
        val validationResult = Name.validate(value)
        assertTrue(validationResult.isValid)
    }

    @Test
    fun validate_tooLongValue_returnsErrorId() {
        val value = "A".repeat(51)
        val validationResult = Name.validate(value)
        assertFalse(validationResult.isValid)
        assertNotNull(validationResult.errorMessageId)
    }

    @Test
    fun toString_validValue_printsValue() {
        val name = Name.create("Abc")
        assertEquals("Abc", name.toString())
    }
}