package net.damschen.swatchit.ui.viewmodels

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableSharedFlow
import kotlinx.coroutines.flow.SharedFlow
import kotlinx.coroutines.flow.asSharedFlow
import kotlinx.coroutines.launch
import net.damschen.swatchit.domain.repositories.SwatchRepository
import net.damschen.swatchit.domain.resultWrappers.DatabaseResult
import net.damschen.swatchit.ui.models.SwatchFormStateManager
import net.damschen.swatchit.ui.providers.DateTimeProvider
import javax.inject.Inject

@HiltViewModel
class AddSwatchViewModel @Inject constructor(
    private val swatchRepository: SwatchRepository,
    dateTimeProvider: DateTimeProvider
) : ViewModel() {

    val formManager = SwatchFormStateManager(dateTimeProvider)
    private val _savedSuccessfully = MutableSharedFlow<Boolean>()
    val savedSuccessfully: SharedFlow<Boolean> = _savedSuccessfully.asSharedFlow()

    init {
        formManager.resetFormState()
    }

    fun addSwatch() {
        viewModelScope.launch {
            if (!formManager.swatchFormState.value.isValid()) {
                _savedSuccessfully.emit(false)
                return@launch
            }

            val swatchFormState = formManager.swatchFormState.value
            val swatch = swatchFormState.toSwatch()
            val result = swatchRepository.add(swatch)
            val success = result is DatabaseResult.Success
            if (success) formManager.resetFormState()
            _savedSuccessfully.emit(success)
        }
    }
}
