package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize
import net.damschen.swatchit.domain.aggregates.swatch.Measurement
import net.damschen.swatchit.ui.enums.CountType
import net.damschen.swatchit.ui.enums.toDataEnum

data class MeasurementFormState(
    val count: ValidatedInput,
    val size: ValidatedInput,
    val type: CountType
) {
    fun isValid(): Boolean = count.isValid() && size.isValid()

    fun toMeasurement(): Measurement = Measurement(
        GaugeCount.create(count.value),
        GaugeSize.create(size.value),
        type.toDataEnum()
    )
}