package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.Gauge
import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize


data class GaugeState(
    val nrOfStitches: Int,
    val nrOfRows: Int,
    val gaugeSize: Double
) {
    companion object {
        fun fromGauge(gauge: Gauge): GaugeState {
            return GaugeState(
                nrOfStitches = gauge.nrOfStitches.value,
                nrOfRows = gauge.nrOfRows.value,
                gaugeSize = gauge.size.value
            )
        }
    }

    fun toGauge(): Gauge =
        Gauge(
            nrOfStitches = GaugeCount(nrOfStitches), nrOfRows = GaugeCount(nrOfRows),
            size = GaugeSize(gaugeSize)
        )
}