package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.Gauge
import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize


data class GaugeFormState(
    val nrOfStitches: ValidatedInput,
    val nrOfRows: ValidatedInput,
    val size: ValidatedInput,
) {
    val isEmpty get() = nrOfStitches.isBlank() && nrOfStitches.isBlank() && size.isBlank()

    companion object {
        fun init(): GaugeFormState = GaugeFormState(
            ValidatedInput(""), ValidatedInput(""),
            ValidatedInput("")
        )

        fun fromGauge(gauge: Gauge?): GaugeFormState {
            return gauge?.let {
                GaugeFormState(
                    nrOfStitches = ValidatedInput(it.nrOfStitches.toString()),
                    nrOfRows = ValidatedInput(it.nrOfRows.toString()),
                    size = ValidatedInput(it.size.toString())
                )
            } ?: init()
        }
    }

    fun isValid(): Boolean = nrOfStitches.isValid() && nrOfRows.isValid() && size.isValid()

    fun toGauge(): Gauge = Gauge(
        nrOfStitches = GaugeCount.create(nrOfStitches.value),
        nrOfRows = GaugeCount.create(nrOfRows.value),
        size = GaugeSize.create(size.value)
    )
}