package net.damschen.swatchit.ui.models

import androidx.annotation.StringRes
import net.damschen.swatchit.domain.aggregates.swatch.Gauge

data class GaugeCalculationState(
    val gaugeState: GaugeState?,
    @field:StringRes val errorMessageId: Int?
) {
    companion object {
        fun fromGauge(gauge: Gauge): GaugeCalculationState {
            return GaugeCalculationState(
                GaugeState.fromGauge(gauge), null
            )
        }
    }

    fun toGauge(): Gauge? = if (errorMessageId == null) gaugeState?.toGauge() else null
}