package net.damschen.swatchit.ui.enums

import net.damschen.swatchit.domain.aggregates.swatch.MeasurementType

enum class CountType {
    Stitches,
    Rows
}

fun MeasurementType.toCountType() = when (this) {
    MeasurementType.Rows -> CountType.Rows
    MeasurementType.Stitches -> CountType.Stitches
}

fun CountType.toDataEnum() = when (this) {
    CountType.Rows -> MeasurementType.Rows
    CountType.Stitches -> MeasurementType.Stitches
}