package net.damschen.swatchit.infrastructure.services

import android.content.Context
import android.graphics.Bitmap
import android.net.Uri
import coil3.ImageLoader
import coil3.imageLoader
import coil3.request.ErrorResult
import coil3.request.ImageRequest
import coil3.request.SuccessResult
import coil3.request.allowHardware
import coil3.size.Scale
import coil3.size.Size
import coil3.toBitmap

interface BitmapDecoder {
    suspend fun decode(uri: Uri, maxSize: Int?): Bitmap
}

class CoilBitmapDecoder(
    private val context: Context
) : BitmapDecoder {

    private val imageLoader: ImageLoader by lazy {
        context.imageLoader
    }

    override suspend fun decode(uri: Uri, maxSize: Int?): Bitmap {
        val request = ImageRequest.Builder(context)
            .data(uri)
            .size(maxSize?.let { Size(it, it) } ?: Size.ORIGINAL)
            .scale(Scale.FIT)
            .allowHardware(false)
            .build()

        return when (val result = imageLoader.execute(request)) {
            is SuccessResult -> result.image.toBitmap()
            is ErrorResult -> throw result.throwable
        }
    }
}