package net.damschen.swatchit.infrastructure.database

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.Query

@Dao
interface MeasurementDao {
    @Query("SELECT * FROM measurements WHERE swatchId = :swatchId")
    suspend fun getBySwatchId(swatchId: Int): List<MeasurementEntity>

    @Insert
    suspend fun insert(measurement: MeasurementEntity)

    @Insert
    suspend fun insert(measurements: List<MeasurementEntity>)

    @Query("DELETE FROM measurements WHERE swatchId = :swatchId")
    suspend fun deleteAllForSwatch(swatchId: Int)
}