package net.damschen.swatchit.domain.resultWrappers

import androidx.annotation.StringRes

class ValidationResult private constructor(
    val isValid: Boolean,
    @field:StringRes val errorMessageId: Int? = null
) {
    companion object {
        fun success(): ValidationResult {
            return ValidationResult(true, null)
        }

        fun error(@StringRes errorMessageId: Int?): ValidationResult {
            return ValidationResult(false, errorMessageId)
        }
    }
}