package net.damschen.swatchit.domain.aggregates.swatch

data class Yarn(val name: Name?, val manufacturer: Name?) {
    init {
        require(name != null || manufacturer != null) {
            "Yarn must have at least a name or manufacturer"
        }
    }

    companion object {
        fun create(name: Name?, manufacturer: Name?): Yarn? {
            if (name == null && manufacturer == null) return null

            return Yarn(name, manufacturer)
        }
    }
}
