package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.R
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

@JvmInline
value class Pattern private constructor(val value: String) {
    init {
        require(validate(value).isValid) { "Pattern invalid" }
    }

    companion object {
        fun validate(value: String): ValidationResult {
            return when {
                value.length > MAX -> ValidationResult.error(R.string.required_max_150)
                else -> ValidationResult.success()
            }
        }

        fun create(value: String): Pattern? {
            if (value.isBlank()) return null
            return Pattern(value)
        }
    }

    override fun toString(): String = value
}

private const val MAX = 150