package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.R
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

@JvmInline
value class Notes private constructor(val value: String) {
    init {
        require(validate(value).isValid) { "Notes invalid" }
    }

    companion object {
        fun validate(value: String): ValidationResult {
            return when {
                value.length > MAX -> ValidationResult.error(R.string.max_500)
                else -> ValidationResult.success()
            }
        }

        fun create(value: String): Notes? {
            if (value.isBlank()) return null
            return Notes(value)
        }
    }

    override fun toString(): String = value
}

private const val MAX = 500