package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.R
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

@JvmInline
value class Name private constructor(val value: String) {
    init {
        require(validate(value).isValid) { "Name invalid" }
    }

    companion object {
        fun validate(value: String): ValidationResult {
            return when {
                value.length > MAX -> ValidationResult.error(R.string.max_50)
                else -> ValidationResult.success()
            }
        }

        fun create(value: String): Name? {
            if (value.isBlank()) return null
            return Name(value)
        }
    }

    override fun toString(): String = value
}

private const val MAX = 50