package net.damschen.swatchit.domain.aggregates.swatch

import net.damschen.swatchit.R
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

@JvmInline
value class GaugeCount(val value: Int) {
    init {
        require(validate(value).isValid) { "Count invalid" }
    }

    companion object {
        fun validate(value: Int): ValidationResult {
            return when {
                value < MIN -> ValidationResult.error(R.string.must_be_greater_than_zero)
                value > MAX -> ValidationResult.error(R.string.max_99)
                else -> ValidationResult.success()
            }
        }

        fun validate(value: String): ValidationResult {
            val trimmed = value.trim()
            val count = trimmed.toIntOrNull()
            return when {
                trimmed.isBlank() -> ValidationResult.error(R.string.mandatory)
                count == null -> ValidationResult.error(R.string.invalid_number)
                else -> validate(count)
            }
        }

        fun create(value: String): GaugeCount {
            val trimmed = value.trim()
            require(validate(trimmed).isValid) { "Count invalid" }
            return GaugeCount(trimmed.toInt())
        }
    }

    override fun toString(): String {
        return value.toString()
    }
}

private const val MIN = 1
private const val MAX = 99