package net.damschen.swatchit.di

import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent
import net.damschen.swatchit.domain.repositories.SwatchRepository
import net.damschen.swatchit.infrastructure.database.MeasurementDao
import net.damschen.swatchit.infrastructure.database.SwatchDao
import net.damschen.swatchit.infrastructure.database.TransactionProvider
import net.damschen.swatchit.infrastructure.repository.SqlSwatchRepository
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
object RepositoryModule {
    @Provides
    @Singleton
    fun provideSwatchRepository(
        swatchDao: SwatchDao,
        measurementDao: MeasurementDao,
        transactionProvider: TransactionProvider
    ): SwatchRepository = SqlSwatchRepository(swatchDao, measurementDao, transactionProvider)
}