package net.damschen.swatchit.di

import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent
import net.damschen.swatchit.domain.providers.UUIDProvider
import net.damschen.swatchit.infrastructure.providers.UUIDProviderImpl
import net.damschen.swatchit.ui.providers.DateTimeProvider
import net.damschen.swatchit.ui.providers.DateTimeProviderImpl
import javax.inject.Singleton

@Module
@InstallIn(SingletonComponent::class)
object DateTimeProviderModule {
    @Provides
    @Singleton
    fun provideDateTimeProvider(): DateTimeProvider = DateTimeProviderImpl()
}

@Module
@InstallIn(SingletonComponent::class)
object UUIDProviderModule {
    @Provides
    @Singleton
    fun provideUUIDProvider(): UUIDProvider = UUIDProviderImpl()
}