@file:OptIn(ExperimentalCoroutinesApi::class)

package net.damschen.swatchit.test.ui.viewmodels

import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.test.advanceUntilIdle
import kotlinx.coroutines.test.runTest
import net.damschen.swatchit.shared.testhelpers.MainDispatcherRule
import net.damschen.swatchit.test.testHelpers.database.FakeRepo
import net.damschen.swatchit.ui.models.LoadState
import net.damschen.swatchit.ui.viewmodels.SwatchListViewModel
import org.junit.Assert.assertTrue
import org.junit.Rule
import org.junit.Test

class SwatchListViewModelTests {
    @get:Rule
    val mainDispatcherRule = MainDispatcherRule()

    @Test
    fun init_RepositoryReturnsSuccess_loadsSwatches() = runTest {
        val repo = FakeRepo()
        val sut = SwatchListViewModel(repo)
        advanceUntilIdle()

        assertTrue(sut.loadState.value is LoadState.Success)
    }

    @Test
    fun init_RepositoryReturnsError_setsErrorLoadState() = runTest {
        val repo = FakeRepo()
        repo.returnError = true
        val sut = SwatchListViewModel(repo)
        advanceUntilIdle()

        assertTrue(sut.loadState.value is LoadState.Error)
    }
}