@file:OptIn(ExperimentalCoroutinesApi::class)

package net.damschen.swatchit.test.ui.viewmodels

import kotlinx.coroutines.ExperimentalCoroutinesApi
import kotlinx.coroutines.launch
import kotlinx.coroutines.test.UnconfinedTestDispatcher
import kotlinx.coroutines.test.advanceUntilIdle
import kotlinx.coroutines.test.runTest
import net.damschen.swatchit.shared.testhelpers.FakeDateTimeProvider
import net.damschen.swatchit.shared.testhelpers.MainDispatcherRule
import net.damschen.swatchit.test.testHelpers.database.FakeRepo
import net.damschen.swatchit.ui.viewmodels.AddSwatchViewModel
import org.junit.Assert.assertFalse
import org.junit.Assert.assertTrue
import org.junit.Rule
import org.junit.Test

class AddSwatchViewModelTests {

    @get:Rule
    val mainDispatcherRule = MainDispatcherRule()

    @Test
    fun addSwatch_repositoryReturnsSuccess_emitsSuccess() = runTest {
        val repo = FakeRepo()
        val sut = AddSwatchViewModel(repo, FakeDateTimeProvider())

        val values = mutableListOf<Boolean>()
        backgroundScope.launch(UnconfinedTestDispatcher(testScheduler)) {
            sut.savedSuccessfully.collect {
                values.add(it)
            }
        }

        sut.addSwatch()
        advanceUntilIdle()

        assertTrue(values.last())
    }

    @Test
    fun addSwatch_repositoryReturnsError_emitsError() = runTest {
        val repo = FakeRepo()
        val sut = AddSwatchViewModel(repo, FakeDateTimeProvider())

        val values = mutableListOf<Boolean>()
        backgroundScope.launch(UnconfinedTestDispatcher(testScheduler)) {
            sut.savedSuccessfully.collect {
                values.add(it)
            }
        }
        repo.returnError = true

        sut.addSwatch()
        advanceUntilIdle()

        assertFalse(values.last())
    }

    @Test
    fun addSwatch_invalidInput_emitsError() = runTest {
        val repo = FakeRepo()
        val sut = AddSwatchViewModel(repo, FakeDateTimeProvider())
        sut.formManager.onYarnNameChange("A".repeat(51))
        val values = mutableListOf<Boolean>()
        backgroundScope.launch(UnconfinedTestDispatcher(testScheduler)) {
            sut.savedSuccessfully.collect {
                values.add(it)
            }
        }

        sut.addSwatch()
        advanceUntilIdle()

        assertFalse(values.last())
    }
}