package net.damschen.swatchit.test.ui.models

import junit.framework.TestCase.assertEquals
import junit.framework.TestCase.assertFalse
import junit.framework.TestCase.assertTrue
import net.damschen.swatchit.domain.aggregates.swatch.EpochMillis
import net.damschen.swatchit.domain.aggregates.swatch.Notes
import net.damschen.swatchit.domain.aggregates.swatch.Pattern
import net.damschen.swatchit.domain.aggregates.swatch.Swatch
import net.damschen.swatchit.domain.aggregates.swatch.SwatchId
import net.damschen.swatchit.domain.aggregates.swatch.SwatchName
import net.damschen.swatchit.domain.aggregates.swatch.Yarn
import net.damschen.swatchit.domain.aggregates.swatch.YarnManufacturer
import net.damschen.swatchit.domain.aggregates.swatch.YarnName
import net.damschen.swatchit.shared.testhelpers.testdata.SwatchTestData
import net.damschen.swatchit.ui.enums.KnittingNeedleSize
import net.damschen.swatchit.ui.models.SwatchFormState
import net.damschen.swatchit.ui.models.SwatchState
import net.damschen.swatchit.ui.models.ValidatedInput
import org.junit.Test
import java.time.LocalDate
import java.time.ZoneId

class SwatchFormStateTests {
    @Test
    fun isValid_noErrors_returnsTrue() {
        val swatchFormState = SwatchFormState(
            yarnManufacturer = ValidatedInput.Valid(""),
            yarnName = ValidatedInput.Valid(""),
            pattern = ValidatedInput.Valid(""),
            needleSize = KnittingNeedleSize.SIZE_2_5,
            notes = ValidatedInput.Valid(""),
            createdAt = defaultCreatedAt.value,
            name = ValidatedInput.Valid(""),
            id = 12
        )

        assertTrue(swatchFormState.isValid())
    }

    @Test
    fun isValid_errors_returnsFalse() {
        val swatchFormState = SwatchFormState(
            yarnManufacturer = ValidatedInput.Invalid(
                "",
                1
            ),
            yarnName = ValidatedInput.Valid(""),
            pattern = ValidatedInput.Valid(""),
            needleSize = KnittingNeedleSize.SIZE_2_5,
            notes = ValidatedInput.Valid(""),
            createdAt = defaultCreatedAt.value,
            name = ValidatedInput.Valid(""),
            id = 12
        )

        assertFalse(swatchFormState.isValid())
    }

    @Test
    fun toSwatch_afterFromSwatchState_createsEqualSwatch() {
        val swatch = Swatch.create(
            needleSize = defaultNeedleSize,
            pattern = defaultPattern,
            yarn = defaultYarn,
            notes = defaultNotes,
            createdAt = defaultCreatedAt,
            id = SwatchId(13),
            name = defaultName
        )
        val swatchState = SwatchState.from(swatch)!!
        val swatchFormState = SwatchFormState.fromSwatchState(swatchState)
        val actual = swatchFormState.toSwatch()

        assertEquals(SwatchTestData.from(swatch), SwatchTestData.from(actual))
    }
}

private val defaultName = SwatchName.create("TestName")
private val defaultNeedleSize =
    net.damschen.swatchit.domain.aggregates.swatch.KnittingNeedleSize.SIZE_2_5
private val defaultPattern = Pattern.create("Stockinette")
private val defaultYarn =
    Yarn.create(YarnName.create("Yarn Name"), YarnManufacturer.create("Yarn Manufacturer"))
private val defaultNotes = Notes.create("Test notes!")
private val defaultCreatedAt = EpochMillis(
    LocalDate.of(2025, 2, 17).atStartOfDay(
        ZoneId.of("UTC")
    ).toInstant().toEpochMilli()
)