package net.damschen.swatchit.test.ui.models

import junit.framework.TestCase.assertEquals
import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize
import net.damschen.swatchit.domain.aggregates.swatch.Measurement
import net.damschen.swatchit.ui.models.MeasurementListItem
import net.damschen.swatchit.ui.models.MeasurementsState
import org.junit.Test

class MeasurementsStateTest {
    @Test
    fun fromMeasurements_validList_createsMeasurementsState() {
        val measurement =
            Measurement.Rows(GaugeCount(34), GaugeSize(13.0))
        val state = MeasurementsState.fromMeasurements(listOf(measurement))

        assertEquals(listOf(MeasurementListItem.Rows(34, 13.0)), state.items)
    }
}