package net.damschen.swatchit.test.ui.models

import net.damschen.swatchit.ui.models.MeasurementFormState
import net.damschen.swatchit.ui.models.ValidatedInput
import org.junit.Assert.assertFalse
import org.junit.Assert.assertTrue
import org.junit.Test

class MeasurementFormStateTests {
    @Test
    fun isValid_noErrors_returnsTrue() {
        val measurementFormState = MeasurementFormState.Rows(
            ValidatedInput.Valid("13"),
            ValidatedInput.Valid("10.0")
        )

        assertTrue(measurementFormState.isValid())
    }

    @Test
    fun isValid_errors_returnsFalse() {
        val measurementFormState = MeasurementFormState.Rows(
            ValidatedInput.Invalid("-1", 2),
            ValidatedInput.Valid("10.0")
        )

        assertFalse(measurementFormState.isValid())
    }
}