package net.damschen.swatchit.test.testHelpers

import android.net.Uri
import net.damschen.swatchit.domain.aggregates.swatch.Photo
import net.damschen.swatchit.infrastructure.resultWrappers.PhotoResult
import net.damschen.swatchit.infrastructure.services.PhotoStorageService

class FakePhotoStorageService : PhotoStorageService {
    var returnErrorDuringDelete = false
    var returnError = false
    var deletedPhoto: Photo? = null

    override suspend fun copyToLocalFileSystem(
        uri: Uri,
        photo: Photo
    ): PhotoResult =
        if (returnError) PhotoResult.Error("Fake error during copy") else PhotoResult.Success

    override suspend fun deleteFromLocalFileSystem(photo: Photo): PhotoResult {
        deletedPhoto = photo
        return if (returnErrorDuringDelete || returnError) PhotoResult.Error("Fake error during delete") else PhotoResult.Success
    }
}