package net.damschen.swatchit.test.domain.extensions

import junit.framework.TestCase.assertEquals
import net.damschen.swatchit.domain.extensions.toPlainStringWithoutTrailingZeros
import org.junit.Test

class ExtensionsTests {
    @Test
    fun toPlainStringWithoutTrailingZeros_doubleWithTrailingZero_removesTrailingZero() {
        val number = 13.0
        val actual = number.toPlainStringWithoutTrailingZeros()
        assertEquals("13", actual)
    }

    @Test
    fun toPlainStringWithoutTrailingZeros_doubleWithScientificNotation_removesScientificNotation() {
        val number = 1.3e8
        val actual = number.toPlainStringWithoutTrailingZeros()
        assertEquals("130000000", actual)
    }
}