package net.damschen.swatchit.test.domain.aggregates.swatch

import junitparams.JUnitParamsRunner
import net.damschen.swatchit.domain.aggregates.swatch.Yarn
import net.damschen.swatchit.domain.aggregates.swatch.YarnManufacturer
import net.damschen.swatchit.domain.aggregates.swatch.YarnName
import org.junit.Assert.assertEquals
import org.junit.Test
import org.junit.runner.RunWith

@RunWith(JUnitParamsRunner::class)
class YarnTests {

    @Test
    fun create_validInput_createsYarn() {
        val yarn = Yarn.create(DefaultYarnName, DefaultYarnManufacturer)!!

        assertEquals(DefaultYarnName, yarn.name)
        assertEquals(DefaultYarnManufacturer, yarn.manufacturer)
    }

    @Test
    fun create_nameAndManufacturerNull_returnsNull() {
        val yarn = Yarn.create(null, null)
        assertEquals(null, yarn)
    }
}

private val DefaultYarnName = YarnName.create("Yarn Name")
private val DefaultYarnManufacturer = YarnManufacturer.create("Yarn Manufacturer")
