package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.YarnName
import net.damschen.swatchit.domain.resultWrappers.ValidationResult
import org.junit.Assert.assertEquals
import org.junit.Assert.assertNotNull
import org.junit.Assert.assertThrows
import org.junit.Assert.assertTrue
import org.junit.Test

class YarnNameTests {
    @Test
    fun create_validInput_createsYarnName() {
        val value = "This is a name!"
        val name = YarnName.create(value)!!
        assertEquals(value, name.value)
    }

    @Test
    fun create_emptyInput_returnsNull() {
        val name = YarnName.create("")
        assertEquals(null, name)
    }

    @Test
    fun create_tooLongValue_throws() {
        assertThrows(IllegalArgumentException::class.java) {
            YarnName.create("A".repeat(51))
        }
    }

    @Test
    fun validate_validInput_returnsSuccess() {
        val value = "This is a name!"
        val validationResult = YarnName.validate(value)
        assertTrue(validationResult is ValidationResult.Success)
    }

    @Test
    fun validate_tooLongValue_returnsErrorId() {
        val value = "A".repeat(51)
        val validationResult = YarnName.validate(value)
        assertNotNull((validationResult as ValidationResult.Error).errorMessageId)
    }

    @Test
    fun toString_validValue_printsValue() {
        val name = YarnName.create("Abc")
        assertEquals("Abc", name.toString())
    }
}