package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.YarnManufacturer
import net.damschen.swatchit.domain.resultWrappers.ValidationResult
import org.junit.Assert.assertEquals
import org.junit.Assert.assertNotNull
import org.junit.Assert.assertThrows
import org.junit.Assert.assertTrue
import org.junit.Test

class YarnManufacturerTests {
    @Test
    fun create_validInput_createsYarnManufacturer() {
        val value = "YarnManufacturer!"
        val manufacturer = YarnManufacturer.create(value)!!
        assertEquals(value, manufacturer.value)
    }

    @Test
    fun create_emptyInput_returnsNull() {
        val manufacturer = YarnManufacturer.create("")
        assertEquals(null, manufacturer)
    }

    @Test
    fun create_tooLongValue_throws() {
        assertThrows(IllegalArgumentException::class.java) {
            YarnManufacturer.create("A".repeat(51))
        }
    }

    @Test
    fun validate_validInput_returnsSuccess() {
        val value = "YarnManufacturer!"
        val validationResult = YarnManufacturer.validate(value)
        assertTrue(validationResult is ValidationResult.Success)
    }

    @Test
    fun validate_tooLongValue_returnsErrorId() {
        val value = "A".repeat(51)
        val validationResult = YarnManufacturer.validate(value)
        assertNotNull((validationResult as ValidationResult.Error).errorMessageId)
    }

    @Test
    fun toString_validValue_printsValue() {
        val manufacturer = YarnManufacturer.create("Abc")
        assertEquals("Abc", manufacturer.toString())
    }
}