package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.SwatchName
import net.damschen.swatchit.domain.resultWrappers.ValidationResult
import org.junit.Assert.assertEquals
import org.junit.Assert.assertNotNull
import org.junit.Assert.assertThrows
import org.junit.Assert.assertTrue
import org.junit.Test

class SwatchNameTests {
    @Test
    fun create_validInput_createsSwatchName() {
        val value = "This is a name!"
        val name = SwatchName.create(value)!!
        assertEquals(value, name.value)
    }

    @Test
    fun create_emptyInput_returnsNull() {
        val name = SwatchName.create("")
        assertEquals(null, name)
    }

    @Test
    fun create_tooLongValue_throws() {
        assertThrows(IllegalArgumentException::class.java) {
            SwatchName.create("A".repeat(51))
        }
    }

    @Test
    fun validate_validInput_returnsSuccess() {
        val value = "This is a name!"
        val validationResult = SwatchName.validate(value)
        assertTrue(validationResult is ValidationResult.Success)
    }

    @Test
    fun validate_tooLongValue_returnsErrorId() {
        val value = "A".repeat(51)
        val validationResult = SwatchName.validate(value)
        assertNotNull((validationResult as ValidationResult.Error).errorMessageId)
    }

    @Test
    fun toString_validValue_printsValue() {
        val name = SwatchName.create("Abc")
        assertEquals("Abc", name.toString())
    }
}