package net.damschen.swatchit.test.domain.aggregates.swatch

import net.damschen.swatchit.domain.aggregates.swatch.Pattern
import net.damschen.swatchit.domain.resultWrappers.ValidationResult
import org.junit.Assert.assertEquals
import org.junit.Assert.assertNotNull
import org.junit.Assert.assertThrows
import org.junit.Assert.assertTrue
import org.junit.Test

class PatternTests {
    @Test
    fun create_validInput_createsPattern() {
        val value = "Stockinette"
        val pattern = Pattern.create(value)!!
        assertEquals(value, pattern.value)
    }

    @Test
    fun create_emptyName_returnsNull() {
        val pattern = Pattern.create("")
        assertEquals(null, pattern)
    }

    @Test
    fun create_tooLongValue_throws() {
        assertThrows(IllegalArgumentException::class.java) {
            Pattern.create("A".repeat(151))
        }
    }

    @Test
    fun validate_validInput_returnsSuccess() {
        val value = "Stockinette"
        val validationResult = Pattern.validate(value)
        assertTrue(validationResult is ValidationResult.Success)
    }

    @Test
    fun validate_tooLongValue_returnsErrorMessageId() {
        val value = "A".repeat(151)
        val validationResult = Pattern.validate(value)
        assertNotNull((validationResult as ValidationResult.Error).errorMessageId)
    }

    @Test
    fun toString_validValue_printsValue() {
        val pattern = Pattern.create("Abc")
        assertEquals("Abc", pattern.toString())
    }
}