package net.damschen.swatchit.shared.testhelpers

import android.content.Context
import android.graphics.Bitmap
import java.io.File
import java.io.FileOutputStream

fun createTestImageFileInFileSystem(context: Context) {
    val bitmap = Bitmap.createBitmap(50, 50, Bitmap.Config.ARGB_8888)
    bitmap.eraseColor(android.graphics.Color.BLUE)
    val dir = File(context.filesDir, "images").apply { mkdirs() }

    val file = File(dir, "${FakeUUIDProvider.defaultUUID}.jpg")
    FileOutputStream(file).use { out ->
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, out)
    }
    bitmap.recycle()
}