package net.damschen.swatchit.ui.models

import androidx.annotation.StringRes
import net.damschen.swatchit.domain.resultWrappers.ValidationResult

sealed interface ValidatedInput {
    val value: String

    data class Valid(override val value: String = "") : ValidatedInput

    data class Invalid(
        override val value: String,
        @StringRes val errorMessageId: Int
    ) : ValidatedInput
}

fun ValidatedInput.isBlank(): Boolean = value.isBlank()

fun String.toValidatedInput(validationResult: ValidationResult): ValidatedInput {
    return when (validationResult) {
        is ValidationResult.Success -> ValidatedInput.Valid(this)
        is ValidationResult.Error -> ValidatedInput.Invalid(this, validationResult.errorMessageId)
    }
}