package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.Measurement

data class MeasurementsState(val items: List<MeasurementListItem>) {
    companion object {
        fun fromMeasurements(measurements: List<Measurement>): MeasurementsState {
            return MeasurementsState(measurements.map { it.toListItem() })
        }
    }
}

sealed interface MeasurementListItem {
    val count: Int
    val size: Double

    data class Stitches(
        override val count: Int,
        override val size: Double
    ) : MeasurementListItem

    data class Rows(
        override val count: Int,
        override val size: Double
    ) : MeasurementListItem
}

private fun Measurement.toListItem(): MeasurementListItem = when (this) {
    is Measurement.Stitches -> MeasurementListItem.Stitches(
        count = count.value,
        size = size.value
    )

    is Measurement.Rows -> MeasurementListItem.Rows(
        count = count.value,
        size = size.value
    )
}