package net.damschen.swatchit.ui.models

import net.damschen.swatchit.domain.aggregates.swatch.GaugeCount
import net.damschen.swatchit.domain.aggregates.swatch.GaugeSize
import net.damschen.swatchit.domain.aggregates.swatch.Measurement

sealed interface MeasurementFormState {
    val count: ValidatedInput
    val size: ValidatedInput

    fun isValid(): Boolean =
        count is ValidatedInput.Valid && size is ValidatedInput.Valid

    fun toMeasurement(): Measurement

    data class Stitches(
        override val count: ValidatedInput,
        override val size: ValidatedInput
    ) : MeasurementFormState {
        override fun toMeasurement() = Measurement.Stitches(
            GaugeCount.create(count.value),
            GaugeSize.create(size.value)
        )
    }

    data class Rows(
        override val count: ValidatedInput,
        override val size: ValidatedInput
    ) : MeasurementFormState {
        override fun toMeasurement() = Measurement.Rows(
            GaugeCount.create(count.value),
            GaugeSize.create(size.value)
        )
    }
}