package net.damschen.swatchit.ui.models

import androidx.annotation.StringRes
import net.damschen.swatchit.domain.aggregates.swatch.Gauge

sealed interface GaugeCalculationState {
    data class Valid(val gaugeState: GaugeState) : GaugeCalculationState
    data class Invalid(@StringRes val errorMessageId: Int) : GaugeCalculationState
    data object NotCalculated: GaugeCalculationState

    companion object {
        fun fromGauge(gauge: Gauge): GaugeCalculationState {
            return Valid(GaugeState.fromGauge(gauge))
        }
    }
}