package net.damschen.swatchit.ui.elements

import androidx.compose.foundation.layout.ColumnScope
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.CardDefaults
import androidx.compose.material3.ElevatedCard
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.text.style.TextDecoration
import androidx.compose.ui.unit.dp

@Composable
fun DetailsCard(
    content: @Composable (ColumnScope.() -> Unit)
) {
    ElevatedCard(
        elevation = CardDefaults.cardElevation(
            defaultElevation = 6.dp
        ), modifier = Modifier
            .fillMaxWidth()
            .padding(4.dp), content = content
    )
}

@Composable
fun CardCaption(text: String) {
    Text(
        text = text,
        style = MaterialTheme.typography.headlineMedium,
        textDecoration = TextDecoration.Underline,
        modifier = Modifier.padding(12.dp, 4.dp, 24.dp, 8.dp)
    )
}