package net.damschen.swatchit.ui.elements

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Delete
import androidx.compose.material3.AlertDialog
import androidx.compose.material3.Icon
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.testTag
import androidx.compose.ui.res.stringResource
import net.damschen.swatchit.R

@Composable
fun ConfirmDeleteDialog(
    text: String,
    onDismiss: () -> Unit,
    onConfirmation: () -> Unit,
) {
    AlertDialog(icon = {
        Icon(
            Icons.Default.Delete,
            contentDescription = stringResource(R.string.delete_icon_description)
        )
    }, modifier = Modifier.testTag("ConfirmDeleteDialog"), title = {
        Text(text = stringResource(R.string.are_you_sure))
    }, text = {
        Text(text = text)
    }, onDismissRequest = {
        onDismiss()
    }, confirmButton = {
        TextButton(modifier = Modifier.testTag("ConfirmButton"), onClick = {
            onConfirmation()
        }) {
            Text(stringResource(R.string.confirm))
        }
    }, dismissButton = {
        TextButton(onClick = {
            onDismiss()
        }, modifier = Modifier.testTag("CancelDeleteButton")) {
            Text(stringResource(R.string.dismiss))
        }
    })
}