package net.damschen.swatchit.infrastructure.database

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import java.util.UUID

@Entity(tableName = "swatches")
data class SwatchEntity(
    @ColumnInfo(name = "needle_size") val needleSize: KnittingNeedleSize,
    @ColumnInfo(name = "yarn_name") val yarnName: String,
    @ColumnInfo(name = "yarn_manufacturer") val yarnManufacturer: String,
    @ColumnInfo(name = "nr_of_stitches") val nrOfStitches: Int? = null,
    @ColumnInfo(name = "nr_of_rows") val nrOfRows: Int? = null,
    @ColumnInfo(name = "gauge_length") val gaugeLength: Double? = null,
    @ColumnInfo(name = "createdAt") val createdAt: Long,
    @ColumnInfo(name = "name") val name: String,
    @ColumnInfo(name = "pattern") val pattern: String,
    @ColumnInfo(name = "notes") val notes: String,
    @ColumnInfo(name = "photoUUID") val photoUUID: UUID?
) {
    @PrimaryKey(autoGenerate = true)
    var id: Int = 0
}

data class SwatchId(val id: Int)

enum class KnittingNeedleSize {
    SIZE_0_5,
    SIZE_0_75,
    SIZE_1_0,
    SIZE_1_25,
    SIZE_1_5,
    SIZE_1_75,
    SIZE_2_0,
    SIZE_2_25,
    SIZE_2_5,
    SIZE_2_75,
    SIZE_3_0,
    SIZE_3_25,
    SIZE_3_5,
    SIZE_3_75,
    SIZE_4_0,
    SIZE_4_25,
    SIZE_4_5,
    SIZE_4_75,
    SIZE_5_0,
    SIZE_5_5,
    SIZE_6_0,
    SIZE_6_5,
    SIZE_7_0,
    SIZE_7_5,
    SIZE_8_0,
    SIZE_9_0,
    SIZE_10_0,
    SIZE_12_0,
    SIZE_15_0,
    SIZE_16_0,
    SIZE_19_0,
    SIZE_20_0,
    SIZE_25_0,
    SIZE_30_0,
    SIZE_35_0;
}

