package net.damschen.swatchit.infrastructure.database

import androidx.room.migration.Migration
import androidx.sqlite.db.SupportSQLiteDatabase

val MIGRATION_2_3 = object : Migration(2, 3) {
    override fun migrate(db: SupportSQLiteDatabase) {
        db.execSQL(
            "UPDATE swatches SET nr_of_stitches = 1 WHERE nr_of_stitches = 0"
        )
        db.execSQL(
            "UPDATE swatches SET nr_of_rows = 1 WHERE nr_of_rows = 0"
        )

        db.execSQL(
            "UPDATE swatches SET gauge_length = 0.1 WHERE gauge_length = 0"
        )

        db.execSQL(
            "UPDATE measurements SET count = 1 WHERE count = 0"
        )

        db.execSQL(
            "UPDATE measurements SET size = 0.1 WHERE size = 0"
        )
    }
}