package net.damschen.swatchit.domain.repositories

import kotlinx.coroutines.flow.Flow
import net.damschen.swatchit.domain.aggregates.swatch.Swatch
import net.damschen.swatchit.domain.aggregates.swatch.SwatchId
import net.damschen.swatchit.domain.resultWrappers.DatabaseResult

interface SwatchRepository {
    fun getAll(): Flow<DatabaseResult<List<Swatch>>>
    suspend fun get(id: Int): DatabaseResult<Swatch?>
    suspend fun add(swatch: Swatch): DatabaseResult<Unit>
    suspend fun update(swatch: Swatch): DatabaseResult<Unit>
    suspend fun delete(id: SwatchId): DatabaseResult<Unit>
}