package net.damschen.swatchit.domain.aggregates.swatch

data class Yarn(val name: YarnName?, val manufacturer: YarnManufacturer?) {
    init {
        require(name != null || manufacturer != null) {
            "Yarn must have at least a name or manufacturer"
        }
    }

    companion object {
        fun create(name: YarnName?, manufacturer: YarnManufacturer?): Yarn? {
            if (name == null && manufacturer == null) return null

            return Yarn(name, manufacturer)
        }
    }
}
